// Buffer.cpp: implementation of the CBuffer class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Buffer.h"
#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

/*#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif*/

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBuffer::CBuffer()
{
	//defaultni konstruktor, kdyz bude volan, vytvori se prazdny retezec
	mBuffer = new char[1]; //alokovani jednoho byte

	*mBuffer = 0; //nastaveni nuloveho znaku
	mVelikost = 0;
	mIsInit = TRUE;
}

CBuffer::CBuffer(int Size) //vytvori buffer o velikosti Size
{
	mBuffer = new char[Size+1]; //alokace pameti
		
	if(mBuffer) //pokud je uspesna
	{
		mBuffer[Size] = 0; //znak 0 ukoncuje retezec
		mVelikost = Size; //nastavime velikost na size
		mIsInit = TRUE; //a inicializaci za provedenou
	}
}

CBuffer::CBuffer(int Size,char Znak)
{
	//vytvori buffer o velikosti Size a nastavi ho na Znak
	mBuffer = new char[Size+1]; //vytvoreni bufferu

	if (mBuffer) //pokud byl buffer vytvoren
	{
		mBuffer[Size] = 0;
		mVelikost = Size; //nastaveni spravne velikosti
		mIsInit = TRUE; //inicializace uz probehla
		SetAt(Znak); //nastaveni retezce na jeden znak
	}
}

CBuffer::CBuffer(char *SBuffer)
{
	//vytvori buffer ze zdrojoveho retezce
	int strSize;
	char* ZdrojBuf = SBuffer;

	strSize = GetStrLen(SBuffer); //ziskani delky

	//alokace pameti
	mBuffer = new char[strSize + 1];

	if (mBuffer)
	{
		mVelikost = strSize; //nastaveni delky a kopirovani retezce
		char* p;
		for (p = mBuffer; p < (mBuffer + mVelikost); p++)
			*p = *ZdrojBuf++;

		*p = 0;
		mIsInit = TRUE;
	}
}

///////////////////////////////////////////////////////////////////////
// Kopirovaci konstruktor
///////////////////////////////////////////////////////////////////////

CBuffer::CBuffer(CBuffer& PuvBuffer)
{
	//kopirovaci konstruktor se musi postarat o prekopirovani vsech polozek a vytvoreni 
	//sveho vlastniho bufferu
	mBuffer = new char[PuvBuffer.mVelikost+1]; //alokace vlastni pameti

	if (mBuffer) //pokud se nova alokace povedla
	{
		mVelikost = PuvBuffer.mVelikost; //nastaveni velikosti

		for (int i=0; i <= mVelikost; i++)  //prekopirovani retezce
			mBuffer[i] = PuvBuffer.mBuffer[i];

		mBuffer[mVelikost] = 0;
		mIsInit = TRUE;
	}
}


///////////////////////////////////////////////////////////////////////
// Deskriptor
///////////////////////////////////////////////////////////////////////

CBuffer::~CBuffer() //pri skonceni obejktu
{
	if(mBuffer) //byla alokovana pamet?
	{
		delete(mBuffer); //asi jo, takze uvolneni pameti
    }
	mBuffer = NULL; //vynulovani ukazatele, ted neukazuje nikam
	mVelikost = 0; //nulova velikost
	mIsInit = FALSE; //a neinicializovano
}

////////////////////////////////////////////////////////////////////////
// Metody
////////////////////////////////////////////////////////////////////////
void CBuffer::SetAt(char Znak)
{
	if (!mIsInit)
		return;
	//budeme pouziavt ukazatel p, ktery nastavime na zacatek bufferu
	//cyklus pobezi tak dlouho dokud adresa v p bude mensi nez nez mBuffer+mveliksot, proste dokud bude ukazovat do retezce
	//konecne iknkremantace
	//pouziti ukazatele je rychlejsi, protoze pocitac jen inkrementuje adresu a nemusi ji pocitat
	//kdybychom pouzili zapis mBuffer[i], musel by pocitat adresu jako adrseu mBuffer + i, to je pomalejsi
	for(char* p=mBuffer; p < (mBuffer + mVelikost); p++) //cyklem naplnime vlastne pole znakem Znak
		*p = Znak;
}

///////////////////////////////////////
//zapise znak Znak na pozici Pos
///////////////////////////////////////
int CBuffer::WriteAt(int Pos,char Znak)
{
	if (Pos >= mVelikost || !mIsInit) //kdyz je pozice vetsi nez je velikost retezce, vratime -1 jako chybu
		return -1;

	mBuffer[Pos] = Znak; //jinak zmenime znak
	return 0; //vratime 0 jako ze je fse OK
}

/////////////////////////////////////
//vrati znak z pozice Pos
/////////////////////////////////////
char CBuffer::GetChar(int Pos)
{
	if (Pos >= mVelikost || !mIsInit) //kdyz je pozice vetsi nez velikost bufferu, nebo nebylo inicializovano
		return 0;  //vratime nulovy znak

	return mBuffer[Pos]; //jinak vratime znak z pozice Pos
}

////////////////////////////////////
////////////////////////////////////
void CBuffer::StandardOut()
{
	MessageBox(NULL,(LPCTSTR)mBuffer,"Vypis",MB_OK);
}

////////////////////////////////////////////////////////////
//funkce vrati delku retezce s nulovym znakem
////////////////////////////////////////////////////////////
long CBuffer::GetLength()
{
	return mVelikost;
}

////////////////////////////////////////////////////////////
//fce vraci ukazatel na clenskou promennou mBuffer, tedy na uchovavany retezec
///////////////////////////////////////////////////////////////////////////////
char* CBuffer::GetBuffer()
{
	return mBuffer;
}

///////////////////////////////////////////////////////////////////////////
//MakeEmpty
///////////////////////////////////////////////////////////////////////////
void CBuffer::MakeEmpty()
{
	if (mIsInit)
	{
		//fce vytvori nulovy retezec, uvolni alokovanou pamet a alokuje novou o velikosti 1 bajt
		delete(mBuffer); //uvolneni retezce

		mBuffer = new char[1]; //string o velikosti 0
		*mBuffer = 0; //nulovy znak
		mVelikost = 0;
	}
}

////////////////////////////////////////////////////////////////////////
//vraci zda je prvni znak nulovy a velikost je 0
///////////////////////////////////////////////////////////////////////
BOOL CBuffer::IsEmpty()
{
	if (!*mBuffer && !mVelikost)	//pokud je prvni znak nula delka je taky nula
		return TRUE;				//jde o prazdny retezec
	else
		return FALSE;				//nejde o prazdny retezec
}

///////////////////////////////////////////////////////////
//prevede pismena v Ascii retezci bufferu na velka
//////////////////////////////////////////////////////////
void CBuffer::MakeUpper()
{
	if (!mIsInit) //kdyz nebyla inicializace
		return;

	for (char* p=mBuffer; p < (mBuffer + mVelikost); p++)
	{
		//v cyklu budeme prevadet pismena na velka, musime ale koukat jestli uy velka jsou
		if (*p >= 97 && *p <= 122) //znak male a ma cislo 97 a male z 122, pismeno musi byt male
			*p -= 32; //aby se prevedlo na velke a zaroven tak docilime toho, ze se bude pracovat jen s pismeny
	}
}

///////////////////////////////////////////////////////////
//prevede pismena v Ascii retezci na male
//////////////////////////////////////////////////////////
void CBuffer::MakeLower()
{
	if (!mIsInit) //kdyz nebyla inicializace
		return;

	for (char* p=mBuffer; p < (mBuffer + mVelikost); p++) //zase se musime koukat zdase jedna o velka pismena, ktere maji cisla v ascii od 65 do 90
	{
		if (*p >= 65 && *p <= 90)
			*p += 32;
	}
}

///////////////////////////////////////////////////////////
//prevede jedno pismeno v retezci na velke
///////////////////////////////////////////////////////////
void CBuffer::MakeUpper(int Pos)
{
	if (!mIsInit) //kdyz nebyla inicializace
		return;

	if (mBuffer[Pos] >= 97 && mBuffer[Pos] <= 122)
		mBuffer[Pos] -= 32;
}

///////////////////////////////////////////////////////////
//prevede jedno pismeno v retezci na male
///////////////////////////////////////////////////////////
void CBuffer::MakeLower(int Pos)
{
	if (!mIsInit)
		return;

	if (mBuffer[Pos] >= 65 && mBuffer[Pos] <= 90)
		mBuffer[Pos] += 32;
}

///////////////////////////////////////////////////////////
//fce Mid
///////////////////////////////////////////////////////////
char* CBuffer::Mid(int strPos,int nLength)
{
	//funkce vraci ukazatel na urcity pocet znaku z retezce, ktery je ukoncen nulou, to znamena ze
	//musi alokovat nove misto v pameti a nahrat tam kus retezce a vratit ukazatel na ono misto

	if (strPos < 0 || nLength > mVelikost || !mIsInit) //kontrola zda je pozadavek v mezich retezce a jestli bylo inicializovano
		return NULL;
	
	char* ZdrojBuf=mBuffer; //zdrojovy buffer
	char* CilBuf;

	//**Tady pozor, neco s tim udelat. Kdyz funkce takhle alokuje misto a vrati na nej ukazatel, tak pri skoncnei programu
	//**se to misto neuvolni, musime to udelat sami
	CilBuf = new char[nLength + 1]; //alokace pameti
	//aloujeme tolik mista kolik si prejeme vykopirovat z retezce znaku, +1 samozrejme

	ZdrojBuf += strPos; //nastaveni adresy na misto odkud se zacne kopirovat

	if (CilBuf)
	{
		//pokud se povedla
		//prekopirujeme retezec
		char* p;
		for (p=CilBuf; p < (CilBuf + nLength); p++)
			//p ukazuje do ciloveho bufferu
			*p = *ZdrojBuf++;
		//*ZdrojBuf++ nejdriv se do *p ulozi znak na adrese ZdrojBuf a pak se adresa inkrementuje

		*p = 0; //ulozeni nuly na konec
		return CilBuf; //vraceni ukazatele na vykopirovany retezec
	}
	else
		return NULL;

}

//////////////////////////////////////////////////////////////////////////////////////////
//fce Left vrati odkaz na retezec obsahujici urcity pocet znaku z puvodniho retezce zleva
//////////////////////////////////////////////////////////////////////////////////////////
char* CBuffer::Left(int nLength)
{
	//kontrola jestli muzeme tolik znaku dat
	if (nLength > mVelikost || !mIsInit)
		return NULL;

	char* CilBuf; //ukazatel na novy retezec
	char* ZdrojBuf = mBuffer;

	//alokace noveho mista pro retezec
	CilBuf = new char[nLength + 1];

	if (CilBuf)
	{
		//kopirovani znaku
		char* p;
		for (p = CilBuf; p < (CilBuf + nLength); p++, ZdrojBuf++)
			*p = *ZdrojBuf;

		*p = 0; //ulozeni nuloveho znaku na konec
		return CilBuf;
	}
	else //vratime nulovy ukazatel pokud se nepovedlo alokovat nove misto
		return NULL;

}

//////////////////////////////////////////////////////////////////////////////////////////
//fce Right, jako Left ale z druhe strany
//////////////////////////////////////////////////////////////////////////////////////////
char* CBuffer::Right(int nLength)
{
	//kontrola meze
	if (nLength > mVelikost || !mIsInit)
		return NULL;

	char* CilBuf;
	char* ZdrojBuf = mBuffer;

	//alokace
	CilBuf = new char[nLength + 1];

	if (CilBuf)
	{
		//nastaveni pocatecni adresy ZdrojBuf
		ZdrojBuf += (mVelikost - nLength);
		char* p;
		for (p = CilBuf; p < (CilBuf + nLength); p++, ZdrojBuf++)
			*p = *ZdrojBuf;

		*p = 0;
	    return CilBuf;
	}
	else
		return NULL;

}

///////////////////////////////////////////////////////////////////////////////////////////
//fce TrimLeft
///////////////////////////////////////////////////////////////////////////////////////////
void CBuffer::TrimLeft()
{
	if (mIsInit)
	{
		//fce musi zjistit kolik mezer se skryva na leve strane retezce
		int PocMez; //pocet mezer v  retezci 
		char* TmpBuf = mBuffer; //pro kopirovani z puvodniho retezce
		char* TmpBuf2 = TmpBuf; //abychom porad znali adresu puvodniho retezce

		PocMez = GetSpaceCount(TRUE); //ziskani poctu mezer

		if (!PocMez) //pokud je pocet mezer nuklovy, nema cenu se tu zdrzovat
			return;

		//jinak realokace
		mBuffer = new char[mVelikost - PocMez + 1];

		if (mBuffer)
		{
			//prekopirovani prvku, ale nejdriv pricteni PocMez k TmpBuf, aby se nekopirovaly ony mezery
			TmpBuf += PocMez;
			mVelikost -= PocMez; //nova delka
			char* p;
			for (p = mBuffer; p < (mBuffer + mVelikost);p++)
				*p = *TmpBuf++;

			delete(TmpBuf2); //smazani puvodniho
			*p = 0; //nulovy znak na konec
		}
		else
			//jinak musime obnovit ukazatel zpet do mBuffer
			mBuffer = TmpBuf;
	}
}

//////////////////////////////////////////////////////////////////////////////////////////
//fce TrimRight
///////////////////////////////////////////////////////////////////////////////////////////
void CBuffer::TrimRight()
{
	if (mIsInit)
	{
		int PocMez;
		char* TmpBuf = mBuffer;
		char* TmpBuf2 = TmpBuf;

		PocMez = GetSpaceCount(FALSE); //pocet mezer zprava

		if (!PocMez) //ma cenu to vubec delat dal?
			return;

		mBuffer = new char[mVelikost - PocMez + 1];

		if (mBuffer)
		{
			mVelikost -= PocMez;
			//kopirovani znaku, skoncime jen o PocMez znaku driv, tj o pocet mezer driv
			char* p;
			for(p = mBuffer; p < (mBuffer + mVelikost);p++)
				*p = *TmpBuf++;

			delete(TmpBuf2);
			*p = 0;
		}
		else
			mBuffer = TmpBuf2;
	}
}

/////////////////////////////////////////////////////////////////////////////////////////
//fce Trim
/////////////////////////////////////////////////////////////////////////////////////////
void CBuffer::Trim()
{
	//nejdriv musime zjistit zda byl objekt inicializovan, pak musime spocitat pocet mezer zleva i zprava
	//pokud bude nulovy, program nemusi dal pokracovat, jinak realokujeme retezec s delkou mensi o pocet mezer
	//pokud se to povede, prekopirujeme stary retezec, jinak vratime ukazatel mBuffer do puvodni hodnoty
	if (mIsInit) //inicializovano?
	{
		int PocMezL,PocMezR;
		char* TmpBuf = mBuffer;
		char* TmpBuf2 = TmpBuf;

		//spocitani mezer zleva + zprava
		PocMezL = GetSpaceCount(TRUE);
		PocMezR = GetSpaceCount(FALSE);
		
		if (!PocMezL && !PocMezR) //pokud je pocet mezer nulovy, tak to nema cenu
			return;

		mBuffer = new char[mVelikost - (PocMezL + PocMezR) + 1]; //nova alokace

		if (mBuffer)
		{
			mVelikost -= (PocMezL + PocMezR); //nova velikost
			TmpBuf += PocMezL; //preskocine mezer na leve strane
			char* p;
			for (p = mBuffer; p < (mBuffer + mVelikost); p++)
				*p = *TmpBuf++; //kopirovani bajtu

			*p = 0; //nulovy znak na konec

			delete(TmpBuf2); //smazani stareho stringu, uvolneni pameti
		}
		else //kdyz neni nova alokace
			mBuffer = TmpBuf2;
	}
}

//////////////////////////////////////////////////////////////////////////////////////////
//funkce pro ziskani delky retezce ktery je ulozen nekde v pameti a ukoncen nulou
///////////////////////////////////////////////////////////////////////////////////////////
int CBuffer::GetStrLen(char* lpStr)
{
	//funkce ma za ukol zacit prochazet pamet na adrese lpStr, kde zacina retezec
	//dokud nenajde znak 0, pocita jeho delku
	char* p;
	for (p=lpStr; *p; p++);
	//cyklus ma vychozi hodnotu na adrese lpStr
	//opakuje se dokud je pravdive *p, cili dokud se na adrese v p nevyskytuje 0
	//inkrementace promennych

	return (p - lpStr);
}

//////////////////////////////////////////////////////////////////////////////////////////
//funkce alokuje urcity pocet bytu podle zadane velikosti
//////////////////////////////////////////////////////////////////////////////////////////
BOOL CBuffer::Alloc(int nSize)
{
	char* TmpBuf = mBuffer; //docasny ukazatel, nastavime ho at ukazuje tam co uz neco mozna je

	//ted se pokusime alokovat pamet o zadane velikosti
	mBuffer = new char[nSize + 1];

	if (mBuffer)
	{
		//pokud se nam povede alokovat pamet, vratime TRUE a zrusime starou alokaci
		delete(TmpBuf);
		mVelikost = nSize;	//nastavime spravnou velikost
		mBuffer[nSize] = 0;	//nulovy znak na konec
		return TRUE;	//vratime true jako ze se to povedlo
	}
	else
	{	
		mBuffer = TmpBuf;	//do mBuffer dame zase ukazatel na starou pamet a tak o ni neprijdeme pokud se nepovede alokace nova
		return FALSE;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////
//FindLast
///////////////////////////////////////////////////////////////////////////////////////////////////////
int CBuffer::FindLast(char c)
{
	int Pos = -1; //pokud tam tohle cislo po pruchodu cyklem zustane, budeme vedet zetam hledany znak neni
	for (char* p = mBuffer; p < (mBuffer + mVelikost);p++)
	{
		if (*p == c)
			Pos = (p - mBuffer);
	}

	return Pos;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////
//FindFirst
////////////////////////////////////////////////////////////////////////////////////////////////////
int CBuffer::FindFirst(char c)
{
	int Pos = -1; //pozice bude na zacatku zase -1, kdyz se v retezci hledany znak nenajde, bude nam to indikovat -1
	for (char* p = mBuffer;p < (mBuffer + mVelikost);p++)	
	{
		if (*p == c)	//pokud najdeme znak
		{
			Pos = (p - mBuffer);	//vypocitame si pozici
			break;	//ukoncime cyklus, pac hledame jeho prvni vyskyt
		}
	}

	return Pos;	//vratime vysledek
}

//////////////////////////////////////////////////////////////////////////////////////////
//vrati pocet mezer
//////////////////////////////////////////////////////////////////////////////////////////
int CBuffer::GetSpaceCount(BOOL iLeft)
{
	char* p = mBuffer;

    if (iLeft) //zleva
	{
		for (p; *p == ' '; p++); //tak dlouho dokud je tam mezera
		return (p - mBuffer); //vrat pocet
	}
	else //zprava
	{
		p += mVelikost - 1; //velikost musime snizit o jedna, protoze prvni znak je vlstane na pozici 0
		//na pozici mVelikost je znak 0
		for (p; *p == ' '; p--); //spocteni mezer
		return (((mBuffer + mVelikost) - p) - 1); //vratime rozdil, odecteme 1, protoze cyklus se zastavi az na dalsim znaku po mezere
	}
}


//////////////////////////////////////////////////////////
//pretizeny operator =
//////////////////////////////////////////////////////////
CBuffer& CBuffer::operator =(CBuffer& ZdrojBuf)
{
    char* CilBuf = ZdrojBuf.mBuffer; //ukazatel na cilovy retezec
	char* TmpBuf = mBuffer; //bude ukazovat na stary buffer, pouyijeme ho k navraceni hodnoty do mBuffer, gdyby se
	//nepovedla nova alokace

	//musime nadeklarovat docasny ukazatel, protoze parametr se predava hodnotou a nesmime tak menit adresu
	//v ukazateli ZdrojBuf.mBuffer

	if (mVelikost != ZdrojBuf.mVelikost) //pokud neni velikost alokovane pameti obou operandu stejna
		//alokace pameti s novou velikosti
	    mBuffer = new char[ZdrojBuf.mVelikost + 1]; //alokace tolik mista kolik je v zdrojovem operandu
	    //+1 na nulovy znak		mVelikost = 0;

	if (mBuffer) //pokud se to povedlo
	{
		mVelikost = ZdrojBuf.mVelikost; //nastaveni spravne velikosti
		char* p;
		for (p = mBuffer; p < (mBuffer + mVelikost); p++) //prekopirovani prvku
			*p = *CilBuf++;

		*p = 0; //nulovy znak na konec retzce

		if (TmpBuf != mBuffer)  //nesmi byt stejne, ukazovali by na stejne misto, to se stane pokud je delka
			//noveho retezce stejna s delkou stareho retezce
			delete(TmpBuf); //smazani stare pameti
	}
	else
		mBuffer = TmpBuf; //zabranime ztrate pameti pokud se nepovede alokovat novou pamet

	//vrati ukayatel na operand na leve strane
	return *this;
}

//////////////////////////////////////////////////////////////
//operator = nahraje do bufferu retezec
//////////////////////////////////////////////////////////////
CBuffer& CBuffer::operator =(char* DestStr)
{
	char* CilBuf = DestStr;
	char* TmpBuf = mBuffer;
	//operator = musi nejdriv zjistit delku retezce na ktery ukazuje ukazatel LPSTR
    int strSize = 0;

	strSize = GetStrLen(DestStr);
	//az skonci cyklus, bude v strSize velikost retezce bez nuloveho znaku
    //alokace pameti nebo jen prekopirovani
	if (strSize != mVelikost)
		mBuffer = new char[strSize + 1]; //alokace pameti tolik jak je dlouhy retezec

	if (mBuffer) //pokud existuje alokovana pamet
	{
		mVelikost = strSize; //nastaveni velikosti stejne jak je velky retezec
		char* p;
		for (p = mBuffer; p < (mBuffer + mVelikost);p++) //prekopirovani retezce
			*p = *CilBuf++;

		*p = 0; //nastaveni konecneho nuloveho znaku

		if (TmpBuf != mBuffer) //ukazatele nesmi byt stejne, jinak by ukazovali na stejne misto a zrusit takove misto, kde je uz
			delete(TmpBuf); //retezec novy by nebylo zrovna idealni
	}
	else
		mBuffer = TmpBuf;

	return *this; //vraceni ukazatele na instanci
}

////////////////////////////////////////////////////////////////////////////////////////////
//operator +=
//deklarace CBuffer& protoze vraci odkaz, ukazatel ana tridu CBuffer
////////////////////////////////////////////////////////////////////////////////////////////

CBuffer& CBuffer::operator +=(CBuffer& ZdrojBuf)
{
	//pokus o realokaci pameti
	mBuffer = (char*)realloc(mBuffer,mVelikost + ZdrojBuf.mVelikost + 1);

	//pokud se to povedlo tak prenastavime velikost a zkopirujeme prvky
	if (mBuffer)
	{
		char* p = (mBuffer + mVelikost); //nastaveni ukazatele na misto kde konci prvni retezec

		for(char* q = ZdrojBuf.mBuffer; q < (ZdrojBuf.mBuffer + ZdrojBuf.mVelikost); q++) //prekoprirovani noveho retezce
			//v mBuffer uz je zkopirovan puvodni retezec, takze musime zacit indexovat od mVelikost + i
			*p++ = *q;

		//q ukazuje na misto kde se nachazi druhy retezec, zase zacne kopirovani z teto adresy na misto *p
		//po skonceni je p adresa mista kam se muze ulozit nulovy znak

		mVelikost += ZdrojBuf.mVelikost; //nastaveni spravne velikosti

		*p = 0; //nastaveni nuloveho znaku
	}	

	return *this;
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//operator += pro retezce v pameti
//////////////////////////////////////////////////////////////////////////////////////////////////
CBuffer& CBuffer::operator +=(char* DestStr)
{
	int   strSize = 0; //sem ulozi velikost retezce

	//spocitani delky retezce DestStr
	strSize = GetStrLen(DestStr);

	//realokace pameti
	mBuffer = (char*)realloc(mBuffer,mVelikost + strSize + 1);
	
	if (mBuffer) //pokud se povedla realokace
	{
		char* p = (mBuffer + mVelikost); //nastaveni na konec puvodniho retezce

		for (char* q = DestStr; q < (DestStr + strSize); q++) //prekopirovani noveho retezce
			*p++ = *q;

		mVelikost += strSize; //spravna velikost

		*p = 0; //nulovy znak na konec	
	}

	return *this;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//operator += ktery prida znak na konec retezce
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
CBuffer& CBuffer::operator += (char nTmpChar)
{
	//pokus o realokaci pameti, funkce realloc vraci:
	//pokud je argument velikost 0 a prvni argument je platny, je pamet uvolnena
	//pokud ne, a je realokace uspesna, je vracen ukazatel na novou pamet a pokud nemuze byt
	//blok v pameti zmenem, zvetsen, je vracen puvodni blok
	mBuffer = (char*)realloc(mBuffer, mVelikost + 2);

	if (mBuffer) //pokud se to povedlo, tak zapis nove veci
	{
		mBuffer[mVelikost] = nTmpChar; //zapsani noveho znaku
		mVelikost++; //zvetseni velikosti
		mBuffer[mVelikost] = 0;	//nulovy znak na konec
	}

	return *this;		
}

WCHAR* CBuffer::GetUnicodeString()
{
	WCHAR* wptrDest = new WCHAR[mVelikost + 1];
	unsigned int convchars;

	MultiByteToWideChar(CP_ACP,0,mBuffer,-1,wptrDest,mVelikost + 1);

	return wptrDest;
}

//****************************************************************************************************************************
//fce pro zapsani formatovaneho textu
//****************************************************************************************************************************
void CBuffer::Format(const char* formatString,...)
{
	Alloc(256);

	va_list ap;
	va_start(ap,formatString);

	vsprintf(mBuffer,formatString,ap);

	va_end(ap);
}